#include <d3d8.h>

#include ".\gsmenu.h"
#include ".\LD10.h"
#include ".\GSEdit.h"
#include ".\GSGame.h"
#include ".\GSInstructions.h"



CGSMenu::CGSMenu()
{

  m_Level.Load( 255 );

}

CGSMenu::~CGSMenu(void)
{
}



void CGSMenu::Display( IDirect3DDevice8* pDevice )
{

  m_Level.Render();

  theApp.m_pd3dDevice->SetRenderState( D3DRS_ALPHABLENDENABLE, FALSE );

  theApp.m_pd3dDevice->SetTextureStageState( 0, D3DTSS_COLOROP, D3DTOP_MODULATE );
  theApp.m_pd3dDevice->SetTextureStageState( 0, D3DTSS_COLORARG1, D3DTA_TEXTURE );
  theApp.m_pd3dDevice->SetTextureStageState( 0, D3DTSS_COLORARG2, D3DTA_DIFFUSE );

  theApp.m_pd3dDevice->SetTextureStageState( 0, D3DTSS_ALPHAOP, D3DTOP_MODULATE );
  theApp.m_pd3dDevice->SetTextureStageState( 0, D3DTSS_ALPHAARG1, D3DTA_TEXTURE );
  theApp.m_pd3dDevice->SetTextureStageState( 0, D3DTSS_ALPHAARG2, D3DTA_DIFFUSE );

  theApp.PrintNiceCentered( 321, 71, "CHAIN REACTION", 0xff000000 );
  theApp.PrintNiceCentered( 320, 70, "CHAIN REACTION" );
  theApp.PrintNiceCentered( 321, 101, "DETONATOR", 0xff000000 );
  theApp.PrintNiceCentered( 320, 100, "DETONATOR", 0xffffd000 );

  theApp.PrintNiceCentered( 320, 160, "Ludum Dare #10" );
  theApp.PrintNiceCentered( 320, 190, "Georg \"Endurion\" Rottensteiner" );

  theApp.PrintNiceCentered( 320, 250, "http://www.georg-rottensteiner.de" );

  int   ButtonYOffset = 380;

  if ( ( theApp.m_MouseX >= 214 )
  &&   ( theApp.m_MouseX < 214 + 64 )
  &&   ( theApp.m_MouseY >= ButtonYOffset )
  &&   ( theApp.m_MouseY < ButtonYOffset + 40 ) )
  {
    if ( theApp.m_MouseButtons & 1 )
    {
      theApp.RenderTextureSection( 214, ButtonYOffset, theApp.m_TexSec[LD10::TEX_PLAY_3] );
    }
    else
    {
      theApp.RenderTextureSection( 214, ButtonYOffset, theApp.m_TexSec[LD10::TEX_PLAY_2] );
    }
  }
  else
  {
    theApp.RenderTextureSection( 214, ButtonYOffset, theApp.m_TexSec[LD10::TEX_PLAY_1] );
  }
  if ( ( theApp.m_MouseX >= 214 + 64 + 20 )
  &&   ( theApp.m_MouseX < 214 + 64 + 20 + 64 )
  &&   ( theApp.m_MouseY >= ButtonYOffset )
  &&   ( theApp.m_MouseY < ButtonYOffset + 40 ) )
  {
    if ( theApp.m_MouseButtons & 1 )
    {
      theApp.RenderTextureSection( 214 + 64 + 20, ButtonYOffset, theApp.m_TexSec[LD10::TEX_EDIT_3] );
    }
    else
    {
      theApp.RenderTextureSection( 214 + 64 + 20, ButtonYOffset, theApp.m_TexSec[LD10::TEX_EDIT_2] );
    }
  }
  else
  {
    theApp.RenderTextureSection( 214 + 64 + 20, ButtonYOffset, theApp.m_TexSec[LD10::TEX_EDIT_1] );
  }
  if ( ( theApp.m_MouseX >= 214 + 2 * 64 + 40 )
  &&   ( theApp.m_MouseX < 214 + 2 * 64 + 40 + 64 )
  &&   ( theApp.m_MouseY >= ButtonYOffset )
  &&   ( theApp.m_MouseY < ButtonYOffset + 40 ) )
  {
    if ( theApp.m_MouseButtons & 1 )
    {
      theApp.RenderTextureSection( 214 + 2 * 64 + 40, ButtonYOffset, theApp.m_TexSec[LD10::TEX_QUIT_3] );
    }
    else
    {
      theApp.RenderTextureSection( 214 + 2 * 64 + 40, ButtonYOffset, theApp.m_TexSec[LD10::TEX_QUIT_2] );
    }
  }
  else
  {
    theApp.RenderTextureSection( 214 + 2 * 64 + 40, ButtonYOffset, theApp.m_TexSec[LD10::TEX_QUIT_1] );
  }

}



void CGSMenu::UpdateFrame( const float fElapsedTime )
{

  m_Level.Update( fElapsedTime );

}



void CGSMenu::OnMouse( int X, int Y, int Buttons )
{

  int   ButtonYOffset = 380;

  if ( ( theApp.m_MouseX >= 214 )
  &&   ( theApp.m_MouseX < 214 + 64 )
  &&   ( theApp.m_MouseY >= ButtonYOffset )
  &&   ( theApp.m_MouseY < ButtonYOffset + 40 ) )
  {
    if ( theApp.m_MouseButtons & 1 )
    {
      OnChar( 'p' );
    }
  }
  if ( ( theApp.m_MouseX >= 214 + 64 + 20 )
  &&   ( theApp.m_MouseX < 214 + 64 + 20 + 64 )
  &&   ( theApp.m_MouseY >= ButtonYOffset )
  &&   ( theApp.m_MouseY < ButtonYOffset + 40 ) )
  {
    if ( theApp.m_MouseButtons & 1 )
    {
      OnChar( 'e' );
    }
  }
  if ( ( theApp.m_MouseX >= 214 + 2 * 64 + 40 )
  &&   ( theApp.m_MouseX < 214 + 2 * 64 + 40 + 64 )
  &&   ( theApp.m_MouseY >= ButtonYOffset )
  &&   ( theApp.m_MouseY < ButtonYOffset + 40 ) )
  {
    if ( theApp.m_MouseButtons & 1 )
    {
      OnChar( 27 );
    }
  }

}



void CGSMenu::OnChar( int iChar )
{

  if ( iChar == 'e' )
  {
    theApp.NextState( new CGSEdit() );
  }
  else if ( iChar == 'p' )
  {
    theApp.NextState( new CGSGame() );
  }
  else if ( iChar == 27 )
  {
    PostMessage( theApp.m_hWnd, WM_CLOSE, 0, 0 );
  }

}



void CGSMenu::OnKeyDown( int iChar )
{

}